//Plumbing inc file

#declare Plumbing = union { 
//Water pipes
#declare PTex = texture { T_Brass_3E }
#declare piperad = .65;
cylinder {<15,0,33.5>, <15,36,33.5>, piperad texture { PTex } } //hot water pipe
cylinder {<15,35.5,33.5>, <15,36,33.5>, piperad pigment { Black }}          //cap
cylinder {<21,0,33.5>, <21,36,33.5>, piperad texture { PTex } } //cold water pipe
cylinder {<21,35.5,33.5>, <21,36,33.5>, piperad pigment { Black }}          //cap
cylinder {<15,34,33.5>, <21,34,33.5>, piperad texture { PTex } }  //cross pipe
cylinder {<18,34,33.5>, <18,34,37.5>, piperad texture { PTex } }  //pipe to handle
cylinder {<18,34,33.5>, <18,65.5,33.5>, piperad texture { PTex } }  //pipe to shower head
object { WBPlate rotate<0,90,0> translate<15,0,33.5> texture { PTex } } 
object { WBPlate rotate<0,90,0> translate<21,0,33.5> texture { PTex } }
//Corner pipe
difference {
        torus { 2.5, piperad rotate<0,0,90> }
        box { <-4,0,-4> <4,-4,4> }
        box { <-4,-4,0> <4,4,4> }              
        texture { PTex } 
        translate<18,65.5,36> 
        }

//Handle
 union {
        cylinder {<0,0,0>, <0,0,0.1875>, 3}
        cylinder {<0,0,0.1875>, <0,0,0.375>, 2.824}
        cone { 0.375*z,  1.0, 1*z, 1.5 }
        cone { 1*z, 1.5,  4*z, 1.125 }
        torus { 2.824, 0.1875 rotate<90,0,0> translate<0,0,0.1875> }       
        translate<18,34,36> 
        texture { PTex }
        }       

//Shower head
 union {
        cylinder {<18,68,36.5>, <18,68,36.6875>, 2}
        cylinder {<18,68,36.6875>, <18,68,36.875>, 1.824}
        torus { 1.824, 0.1875 rotate<90,0,0> translate<18,68,36.7875> }
        cylinder {<18,68,36>, <18,68,38>, piperad}
        cylinder {<18,67.83,37.56>, <18,67,38.77>, piperad}
        
        union {
                cylinder {<0,0,0>, <0,0,.25>, 0.6875}
                cone { 0.25*z,  0.6875, 1.5*z, 1.625 }
                cylinder {<0,0,1.5>, <0,0,2.75>, 1.625}
                cone { 2.775*z,  1.625, 3.55*z, 1.375 }
                cylinder {<0,0,3.5>, <0,0,3.75>, 1.25}
                rotate<35,0,0>
                translate<18,67,38.77>
                }
        texture { PTex }
        } 
  } 